/***************************************************************************
 *   Copyright (C) 2006 by Luis Quintela   *
 *   lois_qu@web.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SKXMLLOADER_H
#define SKXMLLOADER_H
#define LINE_LENGTH 9
#include <qstring.h>
#include <qregexp.h>
#include <qmap.h>
#include <qxml.h>
class SkOption; // see below

class SkCommand;

enum OptRelation{excludes,isLongOpt,isShortOpt};
typedef QMap<QString,SkCommand> SkCommands;
typedef QMap<QString,SkOption> SkOptions;
typedef QMap<QString,OptRelation> FriendOptions;

/**
@author Luis Quintela
*/
class SkXMLLoader : public QXmlDefaultHandler
{
public:
    SkXMLLoader(SkCommands * commList,QString* clistNames);

    ~SkXMLLoader();
	

	bool startElement ( const QString & , 
						const QString & , 
						const QString & qName, 
						const QXmlAttributes & atts ); 

	bool endElement ( 	const QString & namespaceURI, 
						const QString & localName, 
						const QString & qName );


	
	bool fatalError ( const QXmlParseException & exception );

	
private:
	void prepareRegExp(QString reg_exp_string);
	//void insertInRegExp(QRegExp* opt);
	void setOptRegExp();
	QString format(QString txt);

	SkCommands * commandsList;
	QString * commListNames;
	SkCommand *  current_comm;
	SkOption * current_opt;
	QString current_comm_name;
	QString current_opt_name;
	QString reg_exp_buffer;
	bool current_widget_opt;
	
	int friends_count;
};

//#endif
//#ifndef SKCOMMAND_H
//#define SKCOMMAND_H




/**
@author Luis Quintela
*/
class SkCommand{
public:
	
    SkCommand():
	reg_exp(),
	comment(),
	opts_map(0),
	bound_simple_ops(TRUE),
	opts_names(),
	long_opts_names(),
	no_prefix_opts("\\b(")
	{

	}

	
    ~SkCommand()
	{

	}
	
	QString reg_exp;
	QString comment;
	QString no_prefix_opts;
	QStringList long_opts_names;
	QStringList opts_names;	
	SkOptions *opts_map;
	bool bound_simple_ops;

	
};



/////////////////////////////////////////////////
///CLASS SkOption
/////////////////////////////////////////////////

class SkOption{
public:
    SkOption():
	argument(FALSE),
	prefix(),
	widgetComment(),
	comment(),
	friends(0),
	friends_completed(FALSE),
	rexp()	
	{
		
	}

    ~SkOption(){ delete friends;}
	
	

	bool argument;
	bool friends_completed;
	QString prefix;
	QString widgetComment;
	QString comment;
	FriendOptions *friends;
	QRegExp rexp;
};




#endif



