/***************************************************************************
 *   Copyright (C) 2006 by Luis Quintela   *
 *   lois_qu@web.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _SKWIDGET_H_
#define _SKWIDGET_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
class QGridLayout;
class QVBoxLayout;
class QHBoxLayout;
class QLabel;
class SkCheckBox;
class QPushButton;
class KFileDialog;
class QLineEdit;
class KProcess;
class SkPtrVector;


//Constants of checkboxes  -------------------
#define SKCHECKBOX_MINIMUM_SIZE 160
#define NUMBER_OF_CHECKBOXES  8
//--------------------------------------------
//Constants of main Layout -------------------
#define ROWS  2
#define COLLS 0
#define MARGIN 10
#define SPACE 4
//--------------------------------------------
//Constants of buttons Layout ----------------
#define SPACING 4
//--------------------------------------------
//Constants of colls and rows positions ------
#define FIRST_ROW 0
#define FIRST_COLL 0
#define SECOND_ROW 1
#define SECOND_COLL 1
#define THIRD_ROW 2
//#define THIRD_COLL 2 not needed
//--------------------------------------------
//Constants of manual pages as HTML call -----
#define MAN_PROTOCOL "man:"
#define KONQUEROR "konqueror"
#define EMPTY_COMMAND "man"
#define EMPTY_COMMAND_COMMENT "unknowed command\n"
//--------------------------------------------
//Constants of patterns
#define ARGS "(\\s+(?!\\x002D)|=)(\\w*[\\x0021-\\x002F]*[\\x003A-\\x0040]*[\\x005B-\\x0060]*[\\x007B-\\x007E]*)*"
#define PIPE "((\\s&\\s)|(\\s\\|\\s))"
#define SINGLE_OPTS "\\s+\\-\\w+"
#define OPTS "\\s+\\-+\\w+"
//---------------------------------------------
#include <qwidget.h>
#include "skxmlloader.h"

enum State{searchingFirstPos,takingCommand,takingOpts};

/**
 *
 * @author Luis Quintela <lois_qu@web.de>
 * @version 0.1
 */
class SkWidget : public QWidget
{
    Q_OBJECT


	
public:
 
	/**
	*you can call this constructor without arguments, on this way you have a main-GUI 
	*with 8 checkboxes, two buttons and a label. When you are using a odd number for the
	*parameter <code>checkboxes</code> then the GUI will have 
	*<code>checkboxes-1</code> checkboxes.
	*
	*@param checkboxes is a <code>int</code> greater than zero, default is 8 
	*/
	SkWidget(QWidget * parent = 0,const int checkboxes=NUMBER_OF_CHECKBOXES);
    /**
     * Default Destructor
     */
    virtual ~SkWidget();

  


	
public slots:
   /*$PUBLIC_SLOTS$*/
   
   // SLOTS FOR TO CHANGE THE STATE (current_command)-----------------------------------------------
   
   
   // END OF SLOTS FOR TO CHANGE THE STATE (current_command)----------------------------------------
   
   // SLOTS FOR THE WORK WITH THE COMMAND OPTIONS (checkboxes)------------------------------------------
   
   	/**
	*@post this slot put all checkboxes in the state:<br>
	*- disabled
	*- unchecked
	*- *long_opt == 0 //null QString-pointer
	*- short_opt == 0 //null character
	*- comment   == 0 //null QString-pointer
	*/
	void initCheckBoxes();


	/**
	*this slot 
	*@param opt is a <code>QString</code>
	*/
	void 	changedOption(const bool checked,const QString& opt);

	
	// END OF SLOTS FOR THE WORK WITH THE COMMAND OPTIONS (checkboxes)---------	
	
	
	// SLOTS FOR THE WORK WITH THE BUTTONS ------------------------------------
	/**
	* this slot shows the man page of the command as html in Konqueror 
	*and works with the info button.
	*/
    void     openManual();
    /**
    * this slot call an open file dialog and works with the button open.
    */
    void     openFile();
	/**
    * this slot call an open directory dialog and works with the button open.
    */
    void     openDir();
	// END OF SLOTS FOR THE WORK WITH THE  BUTTONS------------------------------
	
	// SLOTS FOR THE WORK WITH THE LABEL (info) --------------------------------

	/**
	*this slot //TODO comment
	*@param txt is a <code>QString&</code>
	*/
	void textChanged ( const QString & txt);
		/**
	*this slot //TODO comment
	*/
	void skCheckBoxPressed (){pressed=TRUE;}
	/**
	*this slot //TODO comment
	*/
	void doReturn();

	// END OF SLOTS FOR THE WORK WITH THE LABEL(info) --------------------------

protected:
	/**
	* returns the index of a checkbox, which are representing an option of the current command.
	* When there is not a valid parameter it returns -1.
	*@param short_opt 
	*@pre short_opt should be a short form of an selected option of the current command.
	*@post result is the index of a checkbox, which are representing an option of the current command.
	*/
	int getIndexOfOpt(const QString searched_opt);


private:
	

	void makeGUI();
	void makeCheckBoxes( );
	bool loadCommandsFromXMLFile(QString path);
	void makeCommandGUI();
	void setInOptionsPart(QString opt,bool setter=FALSE);
	QString getOptionsPart();
	void setInArgsPart(QString arg);
	void searchFirstPos( const QString & txt,int pos=0  );
	void matchOption( const QString & txt,int offset=0,int end=0 );
	void matchCommand( const QString & txt,int pos=0 );
	void init(bool pipe=FALSE);
	int calculatePos(QString txt,QString regexp, uint firstPos=0);



	
	//Layouts
	QGridLayout 	*main; 		//main layout
	QGridLayout 	*midle;		//contains info label and buttons
	QVBoxLayout		*buttons;	//contains the buttons
	
	//Widgets

	QLineEdit 		*console;	
	QPushButton 	*open_file;		//for the open file dialog
	QPushButton 	*open_dir;		//for the open directory dialog
	QPushButton 	*man;		//for the info from manual
	QLabel 			*info;		//for feedback
	QString			dir;		//for the openDialogs
	
	//Control variables
	int number_of_checkboxes ;	//number of checkboxes to runtime. Default is SKCHECKBOX_MINIMUM_SIZE	
	SkCheckBox   **list;		//schecboxes pointer array for working with them	
	SkCommands  commList;		//QMap<QString,SkCommand> builded from XML-file with information about selected commands
	QString commListNames;		//String for reg. expr. with all comands names as boundary (builded from XML-file)
	QRegExp comms;				//
	QRegExp pipe;
	QRegExp args;
	SkCommand command;	//represents the current command
	QString current_command;	//represents the current command
	State state;
	volatile bool available;
	volatile bool autoPaste;
	volatile bool pressed;
	volatile bool parsed;
	bool pipeline;			//it has first no function
	uint optsPos;
	uint optsBoundPos;
	uint argsPos;
	uint commPos;
	


};

#endif // _SKWIDGET_H_




//BEGIN HEADER OF SkCheckBox

#ifndef SKCHECKBOX_H
#define SKCHECKBOX_H

#include <qcheckbox.h>

/**
 * Class SkCheckBox is properly a QCheckbox with two public QString variables. 
 * @author Luis Quintela
 */

class SkCheckBox : public QCheckBox
{
Q_OBJECT
public:
  /**
   * opt represents an command option of a command line command.
   */
	QString  opt;


  /**
   * the same like QCheckbox
   * @param &text 
   * @param *parent 
   * @param name 
   */
    SkCheckBox (const QString &text=0, QWidget * parent=0, const char * name=0);


    ~SkCheckBox();
	
public slots:
	void changedBox(bool b);
	
signals:
	void changed(const bool,const QString& );

};

#endif
//END HEADER OF SkCheckBox

