/***************************************************************************
 *   Copyright (C) 2006 by Luis Quintela   *
 *   lois_qu@web.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "skkonsole.h"
#include "skwidget.h"
#include <qlabel.h>
#include <kstandarddirs.h>
#include <kmainwindow.h>
#include <klocale.h>

skkonsole::skkonsole()
    : KMainWindow( 0, "skkonsole" )
{
	KStandardDirs *dirs=KGlobal::dirs();
	QString path=dirs->findResource("data","sk_konsole/conf.cf");
	int checkboxes=0;
    QFile file( path );
    if ( file.open( IO_ReadOnly ) ) {
        QTextStream stream( &file );
        QString line;
        int i = 1;
        while ( !stream.atEnd() ) {
            line = stream.readLine(); // line of text excluding '\n'
			if((checkboxes=line.stripWhiteSpace().toInt())!=0)
				break;
        }
        file.close();
    }
    // set the shell's ui resource file
    setXMLFile("skkonsoleui.rc");
	if(checkboxes>0)
		setCentralWidget( new SkWidget ( this ,checkboxes) );
	else
		setCentralWidget( new SkWidget ( this ) );
}

skkonsole::~skkonsole()
{
}

#include "skkonsole.moc"
