var trac_data = new Array();
var trac_storeData = new Array();
var trac_startTime = (new Date()).getTime();

function getXmlHttpObject() {
    var xmlhttp = false;
    /*@cc_on @*/
    /*@if (@_jscript_version >= 5)
    // JScript gives us Conditional compilation, we can cope with old IE versions.
    // and security blocked creation of the objects.
    try {
        xmlhttp = new ActiveXObject("Msxml2.XMLHTTP");
    } catch (e) {
        try {
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
        } catch (E) {
            xmlhttp = false;
        }
    }
    @end @*/
    if (!xmlhttp && typeof XMLHttpRequest != 'undefined') {
        xmlhttp = new XMLHttpRequest();
    }
    return xmlhttp;
}

function secondsSincePageLoad() {
    var d = new Date();
    return Math.round((d.getTime() - trac_startTime) / 1000);
}

function pageHeight() {
    return window.innerHeight != null
        ? window.innerHeight
        : (
            document.body != null
                ? document.body.clientHeight
                : null
          );
}

function pagePosTop() {
    return window.pageYOffset != null
        ? window.pageYOffset
        : (
            document.body.scrollTop != null
                ? document.body.scrollTop
                : 0
          );
}

// http://msdn.microsoft.com/workshop/author/dhtml/reference/properties/offsettop.asp
function elementPosTop(elemId) {
    return document.getElementById(elemId).offsetTop;
}

function elementHeight(elemId) {
    return document.getElementById(elemId).offsetHeight;
}

function track() {
    var tdItem = new Array();
    tdItem['second']       = secondsSincePageLoad();
    tdItem['contentHeight'] = document.body.scrollHeight;
    tdItem['pagePosTop']    = pagePosTop();
    tdItem['pageHeight']    = pageHeight();
    tdItem['markerPosTop']  = elementPosTop('marker');
    tdItem['markerHeight']  = elementHeight('marker');
    trac_data.push(tdItem);

    if (trac_data.length >= 10) {
        trac_storeData = trac_data;
        trac_data = new Array();
        doStoreData();
    }

    document.getElementById('ausgabe').value =
        '  - Informationen - ' + "\n\n" +
        '       second: ' + tdItem['second'] + "\n" +
        'contentHeight: ' + tdItem['contentHeight'] + "\n" +
        '   pagePosTop: ' + tdItem['pagePosTop'] + "\n" +
        '   pageHeight: ' + tdItem['pageHeight'] + "\n" +
        ' markerPosTop: ' + tdItem['markerPosTop'] + "\n" +
        ' markerHeight: ' + tdItem['markerHeight'];
    setTimeout('track()', 1000);
}

// http://www.quirksmode.org/js/events_compinfo.html
//window.onscroll = onwindowscroll;

function getCollectedData() {
    var resultStr = 'trac_sessionId:' + trac_sessionId + "\n";
    resultStr    += 'trac_pageId:'    + trac_pageId    + "\n";
    resultStr    += 'trac_startTime:' + trac_startTime + "\n";
    resultStr    += '-- DATA --'                       + "\n";
    resultStr    += 'second|contentHeight|pagePosTop|pageHeight|markerPosTop|markerHeight' + "\n";
    
    for (i = 0; i < trac_storeData.length; i++) {
        var tdItem = trac_storeData[i];
        resultStr+= tdItem['second']       + '|';
        resultStr+= tdItem['contentHeight'] + '|';
        resultStr+= tdItem['pagePosTop']    + '|';
        resultStr+= tdItem['pageHeight']    + '|';
        resultStr+= tdItem['markerPosTop']  + '|';
        resultStr+= tdItem['markerHeight'];
        resultStr+= "\n";
    }

    return resultStr;
}

function doStoreData() {
    var xmlhttp = getXmlHttpObject();
    xmlhttp.open("POST", 'store.php', true);
    xmlhttp.onreadystatechange = function() {
        if (xmlhttp.readyState == 4) {
            // if "OK"
            if (xmlhttp.status == 200) {
                resp = xmlhttp.responseText;
                if (resp == 'success') {
                    // erstmal nscht
                }

                if (resp == 'failure') {
                    alert('Failed to store Date');
                }
            }
            else {
                alert("Problem retrieving XML data")
            }
        }

    }
    
    resultStr = 'resultStr=' + escape(getCollectedData());
    xmlhttp.setRequestHeader("Content-type","application/x-www-form-urlencoded"); // sending it as encoded formdata
    xmlhttp.setRequestHeader("Content-length", resultStr.length); // we need to specify the length of the contents
    xmlhttp.setRequestHeader("Connection","close"); // Connection is to be closed after transfer
    xmlhttp.send(resultStr);    
}

window.onunload = doStoreData;
setTimeout('track()', 1000);