require 'test_helper'

class UserTest < ActiveSupport::TestCase

  def setup
    # some (valid) Users
    @alex = users(:alex)
    @david = users(:david)

    # some Groups to test against
    @teachers = groups(:teachers)
    @pupils = groups(:pupils)

    # the admin role to test
    @admin = roles(:admin)
    @user = roles(:user)
  end

  def test_should_not_save_user_without_login
    user = User.new(:forename => "Alex", :surname => "Thompson", :password => "geheim", :password_confirmation => "geheim")
    assert !user.save
    user.login = "900"
    assert user.save
  end

  def test_should_not_save_user_without_forename
    user = User.new(:login => "901", :surname => "Thompson", :password => "geheim", :password_confirmation => "geheim")
    assert !user.save
  end

  def test_should_not_save_user_without_surname
    user = User.new(:forename => "Alex", :login => "902", :password => "geheim", :password_confirmation => "geheim")
    assert !user.save
  end

  def test_should_not_save_user_with_duplicate_login
    user1 = User.new(:login => "903", :forename => "Max", :surname => "Mustermann", :password => "geheim", :password_confirmation => "geheim")
    user2 = User.new(:login => "903", :forename => "Maxi", :surname => "Musterfrau", :password => "geheim", :password_confirmation => "geheim")
    assert user1.save
    assert !user2.save
  end

  #testing has and belongs to many association with groups
  test "groups are added to users" do
    assert_difference '@alex.groups.size', 1 do
      @alex.groups << @teachers
    end
    assert_equal @alex.groups.find(@teachers), @teachers
  end

  #testing habtm association with roles
  test "role is given to user" do
    assert_difference '@alex.roles.size', 1 do
      @alex.roles << @admin
    end
    assert_equal @alex.roles.find(@admin), @admin
  end

  #role_symbols is required for decl_authorization
  test "roles are recieved with role_symbols" do
    assert_equal [:admin], @alex.role_symbols

    #adding a role and check new return value
    @alex.roles << @user
    assert_equal [:admin, :user], @alex.role_symbols
  end
end
