require 'test_helper'

class RoleTest < ActiveSupport::TestCase

  def setup
    @admin = roles(:admin)

    # Users to give admin role to
    @david = users(:david)
  end

  test "should not save role without name" do
    @role = Role.new(:name => "")
    assert !@role.save
    @role.name = "admin"
    assert @role.save
  end

  test "role name must be unique" do
    @role = Role.new(:name => "mensaguest")
    @role2 = Role.new(:name => "mensaguest")
    assert @role.save
    assert !@role2.save
  end

  test "role must be between 3 and 20 letters long" do
    @role = Role.new(:name => "me")
    @role2 = Role.new(:name => "abcdefghijklmnopqrstv")
    assert !@role.save
    assert !@role2.save
  end

  test "users ca be added to roles" do
    assert_difference '@admin.users.size', 1 do
      @admin.users << @david
    end
    assert_equal @admin.users.find(@david), @david
  end
end
