require 'test_helper'

class PriceTest < ActiveSupport::TestCase
  def setup
    
    #a Group to add
    @teachers = groups(:teachers)

    #an Article to add
    @ærticle_one = articles(:article_one)
  end

  test "price needs an amount" do
    @price = Price.new
    assert !@price.save

    @price.amount = 10
    assert @price.save
  end

  test "amount is a number" do
    @price = Price.new :amount => "price"
    assert !@price.save
  end

  test "amount is not smaller than zero" do
    @price = Price.new :amount => -1
    assert !@price.save

    @price = Price.new :amount => 0
    assert @price.save
  end

  test "amount is not greater than or equal to one million" do
    @price = Price.new :amount => 1000000
    assert !@price.save

    @price = Price.new :amount => 999999
    assert @price.save
  end

  test "amount has only two digits to the right of the decimal point" do
    @price = Price.new(:amount => 10.005)
    assert @price.save
    #this should round the amount to 10.01

    @newprice = Price.find_by_amount(10.01)
    assert_not_nil @newprice
  end

  test "price can be linked to a group" do
    @price = Price.new :amount => 1
    @price.group = @teachers
    assert_equal @teachers, @price.group
  end

  test "price can be linked to an article" do
    @price = Price.new :amount => 1
    @price.article = @article_one
    assert_equal @article_one, @price.article
  end
end
