require 'test_helper'

class MenuTest < ActiveSupport::TestCase
  setup :activate_authlogic

  def setup
    login_as(:alex)
    @alex = users(:alex)
    @david = users(:david)
    @spaghetti = meals(:spaghetti)
    @snack_one = meals(:toast_hawai)
    @snack_two = meals(:bagel)
    @article_three = articles(:article_three)
    @group_user = users(:group_user)
    @menu_two = menus(:menu_two)
    @price_two = prices(:price_two)
  end

  test "date is obligatory" do
    @menu = Menu.new :meal => @spaghetti, :article => @article_three
    assert !@menu.save

    @menu.date = Date.today.next_week
    assert @menu.save
  end

  test "date is of type date" do
    @menu = Menu.new :date => "No Date", :meal => @spaghetti, :article => @article_three
    assert !@menu.save
  end

  test "menu belongs to a meal" do
    @menu = Menu.new :date => Date.today.next_week, :article => @article_three
    assert !@menu.save

    @menu.meal = @spaghetti
    assert @menu.save
  end

  test "only one menu of the same category per date" do
    @menu = Menu.new :date => Date.today.next_week, :meal => @snack_one, :article => @article_three
    @menu2 = Menu.new :date => Date.today.next_week, :meal => @snack_two, :article => @article_three
    assert @menu.save

    # second menu of the same category (snack) should not be saved for the same date!
    assert !@menu2.save
  end

  test "menu has one article" do
    @menu = Menu.new :date => Date.today.next_week, :meal => @snack_one
    assert !@menu.save

    @menu.article = @article_three
    assert @menu.save
  end

  test "returns a price for a given user" do
    #def price_for_user(user)
    assert_equal @price_two.amount, @menu_two.price_for_user(@group_user)
  end

  test "can select orders for specific user" do
    @orders = Order.find_all_by_user_id_and_sub_order_type_and_article_id(@david.id, "MenuOrder", @menu_two.article.id)
    @menu_orders = @orders.collect {| obj | obj.sub_order }
    assert_equal @menu_two.menu_orders_for_user(@david), @menu_orders
  end

  test "menu_orders returns all MenuOrders for this menu" do
    @orders = Order.find_all_by_sub_order_type_and_article_id("MenuOrder", @menu_two.article.id)
    @menu_orders = @orders.collect {| obj | obj.sub_order }
    assert_equal @menu_two.menu_orders, @menu_orders
  end

  #menu date is the date the menu is served.
  #the day after that billing is enabled
  test "menu-article's billing_date is day after menu_date" do
    @menu = Menu.new :date => @article_three.billing_date.yesterday, :meal => @snack_one, :article => @article_three
    assert @menu.save

    assert_equal @menu.date.next(), @article_three.billing_date

    #this should not work because dates match
    @menu = Menu.new :date => Date.today.next_year, :meal => @snack_one, :article => @article_three
    assert !@menu.save
  end
end
