require 'test_helper'

class MenuOrderTest < ActiveSupport::TestCase
  def setup
    @order_one = orders(:order_one)
    @menu_one = menus(:menu_one)
    @early_mealtime = mealtimes(:early_mealtime)
    @menu_order_three = menu_orders(:menu_order_three)
  end

  test "collected is defaulted to false" do
    @mo = MenuOrder.new :postordered => false, :main_order => @order_one
    assert @mo.save

    assert_equal false, @mo.collected
  end

  test "postordered is defaulted to false" do
    @mo = MenuOrder.new :collected => false, :main_order => @order_one
    assert @mo.save

    assert_equal false, @mo.postordered
  end

  test "MenuOrder has an main_order" do
    @mo = MenuOrder.new :collected => false, :postordered => true
    assert !@mo.save

    @mo.main_order = @order_one
    assert @mo.save
  end

  #this connection is made through Order and Article
  test "MenuOrder belongs to Menu" do
    @mo = MenuOrder.new :main_order => @order_one
    assert_equal @menu_one, @mo.menu
  end

  test "MenuOrder my belong to a mealtime" do
    @mo = MenuOrder.new :main_order => @order_one
    @mo.mealtime = @early_mealtime
    @mo.save

    @mo = MenuOrder.find_by_id @mo.id

    assert_equal @early_mealtime, @mo.mealtime
  end

  test "MenuOrder belongs to a user" do
    assert_equal @menu_order_three.main_order.user, @menu_order_three.user
  end
end
