require 'test_helper'

class MealtimeTest < ActiveSupport::TestCase
 
  def setup
    @menu_order_one = menu_orders(:menu_order_one)
    @menu_order_three = menu_orders(:menu_order_three)
  end

  test "name is required" do
    @mealtime = Mealtime.new :rank => 10, :start_time => "10:00:00", :end_time => "11:00:00", :order_limit => 100
    assert !@mealtime.save

    #add a name
    @mealtime.name = "New Name"
    assert @mealtime.save
  end

  test "name is unique" do
    @mealtime = Mealtime.new :name => "The Same", :rank => 10, :start_time => "10:00:00", :end_time => "11:00:00", :order_limit => 100
    @mealtime2 = Mealtime.new :name => "The Same", :rank => 11, :start_time => "11:00:01", :end_time => "12:00:00", :order_limit => 100
    assert @mealtime.save
    #mealtime2 has the same name as mealtime and should therefore not be saved
    assert !@mealtime2.save
  end

  test "rank is required" do
    @mealtime = Mealtime.new :name => "New Mealtime", :start_time => "10:00:00", :end_time => "11:00:00", :order_limit => 100
    assert !@mealtime.save

    #add a rank
    @mealtime.rank = 10
    assert @mealtime.save
  end

  test "rank is unique" do
    @mealtime = Mealtime.new :name => "New Mealtime One", :rank => 10, :start_time => "10:00:00", :end_time => "11:00:00", :order_limit => 100
    @mealtime2 = Mealtime.new :name => "New Mealtime Two", :rank => 10, :start_time => "11:00:01", :end_time => "12:00:00", :order_limit => 100
    assert @mealtime.save
    #mealtime2 has the same rank as mealtime and should therefore not be saved
    assert !@mealtime2.save
  end

  test "rank is an intger greater zero" do
    @mealtime = Mealtime.new :name => "New Early Mealtime", :rank => 10.5, :start_time => "10:00:00", :end_time => "11:00:00", :order_limit => 100
    #may not be a decimal with numbers to the right the decimal point
    assert !@mealtime.save

    #may not be negative
    @mealtime.rank = -1
    assert !@mealtime.save

    #may not be zero
    @mealtime.rank = 0
    assert !@mealtime.save

    #may not be a String
    @mealtime.rank = "String"
    assert !@mealtime.save
  end

  test "start_time is required" do
    @mealtime = Mealtime.new :name => "New Early Mealtime", :rank => 10, :end_time => "11:00:00", :order_limit => 100
    assert !@mealtime.save

    @mealtime.start_time = "10:00:00"
    assert @mealtime.save
  end

  test "start_time is a time" do
    @mealtime = Mealtime.new :name => "New Early Mealtime", :rank => 10, :end_time => "11:00:00", :order_limit => 100
    
    @mealtime.start_time = "Not a Time"
    assert !@mealtime.save
  end

  test "end_time is required" do
    @mealtime = Mealtime.new :name => "New Early Mealtime", :rank => 10, :start_time => "10:00:00", :order_limit => 100
    assert !@mealtime.save

    @mealtime.end_time = "11:00:00"
    assert @mealtime.save
  end

  test "end_time is a time" do
    @mealtime = Mealtime.new :name => "New Early Mealtime", :rank => 10, :start_time => "10:00:00", :order_limit => 100
    @mealtime.end_time = Date.today
    assert !@mealtime.save

    @mealtime.end_time = "Not a Time"
    assert !@mealtime.save
  end

  test "start_time is earlier than end_time" do
    @mealtime = Mealtime.new :name => "New Early Mealtime", :rank => 10, :start_time => "10:00:00", :end_time => "09:59:59", :order_limit => 100
    assert !@mealtime.save
  end

  test "There is a maximal number of orders set" do
    @mealtime = Mealtime.new :name => "New Early Mealtime", :rank => 10, :start_time => "10:00:00", :end_time => "11:00:00"
    assert !@mealtime.save

    @mealtime.order_limit = 100
    assert @mealtime.save
  end

  test "order_limit is an integer greater than or equal to zero" do
    @mealtime = Mealtime.new :name => "New Early Mealtime", :rank => 10, :start_time => "10:00:00", :end_time => "11:00:00"

    # order_limit may not be negative
    @mealtime.order_limit = -1
    assert !@mealtime.save

    # order_limit may not be a float, double or decimal
    @mealtime.order_limit = 1.56
    assert !@mealtime.save

    # order_limit may not be a string
    @mealtime.order_limit = "String"
    assert !@mealtime.save
  end

  #test has_many association
  test "may have many MenuOrders associated" do
    @mealtime = Mealtime.new :name => "The Same", :rank => 10, :start_time => "10:00:00", :end_time => "11:00:00", :order_limit => 100
    assert @mealtime.save
    
    @mealtime.menu_orders << @menu_order_three
    assert @menu_order_three.save
    assert_equal 1, @mealtime.menu_orders.size
  end
end
