require 'test_helper'

class MealTest < ActiveSupport::TestCase
  
  def setup
    @main_menu = categories(:main_menu)
    @spaghetti = meals(:spaghetti)
    @menu_one = menus(:menu_one)
  end

  test "meal needs a description" do
    @meal = Meal.new :number => 100, :category => @main_menu
    assert !@meal.save

    @meal.description = "Spaghetti Carbonara"
    assert @meal.save
  end

  test "meal needs a number" do
    @meal = Meal.new :description => "Bratwurst", :category => @main_menu
    assert !@meal.save

    @meal.number = 101
    assert @meal.save
  end

  test "number must be an integer" do
    @meal = Meal.new :description => "Bratwurst", :number => "NotANumber", :category => @main_menu
    assert !@meal.save

    @meal.number = 10.45
    assert !@meal.save
  end

  test "number must be greater than zero" do
    @meal = Meal.new :description => "Bratwurst", :number => -1, :category => @main_menu
    assert !@meal.save

    @meal.number = 0
    assert !@meal.save
  end

  test "number must be unique" do
    @meal = Meal.new :description => "Bratwurst", :number => 100, :category => @main_menu
    assert @meal.save

    @meal2 = Meal.new :description => "Keine Bratwurst", :number => 100, :category => @main_menu
    assert !@meal2.save
  end

  test "meal needs a category" do
    @meal = Meal.new :description => "Bratwurst", :number => 100
    assert !@meal.save

    @meal.category = @main_menu
    assert @meal.save
  end
end
