require 'test_helper'

class GroupTest < ActiveSupport::TestCase
  
  def setup
    @teachers = groups(:teachers)
    @pupils = groups(:pupils)
    @alex = users(:alex)
    @david = users(:david)

    @price_one = prices(:price_one)
    @article_one = articles(:article_one)
  end

  test "group requires name and order" do
    # Test without values
    @group = Group.new
    assert !@group.save

    # Test only name set with value
    @group.name = "newGroupName"
    assert !@group.save

    # Test only order set with value
    @group.name = ""
    @group.rank = 100
    assert !@group.save

    # Test correct Group with name and order
    @group.name = "newGroupName"
    assert @group.save
  end

  test "name is unique" do
    @group = Group.new(:name => "a", :rank => 101)
    @group2 = Group.new(:name => "a", :rank => 102)

    assert @group.save
    assert !@group2.save
  end

  test "order is unique" do
    @group = Group.new(:name => "c", :rank => 103)
    @group2 = Group.new(:name => "d", :rank => 103)

    assert @group.save
    assert !@group2.save
  end

  test "order is a number" do
    @group = Group.new(:name => "c", :rank => "notANummber")

    assert !@group.save
  end

  test "order is an integer" do
    @group = Group.new(:name => "c", :rank => 1.5)

    assert !@group.save
  end

  test "oder is greater than zero" do
    @group = Group.new(:name => "c", :rank => -1)
    @group2 = Group.new(:name => "c", :rank => -17)

    assert !@group.save
    assert !@group2.save
  end

  #testing has and belongs to many association
  test "users are added to group" do
    assert_difference '@teachers.members.size', 1 do
      @teachers.members << @alex
    end
    
    assert_not_nil @teachers.members.find(@alex)
  end

  test "prices are added to group" do
    assert_difference '@teachers.prices.size', 1 do
      @teachers.prices << @price_one
    end

    assert_equal @price_one, @teachers.prices.find(@price_one)
  end

  test "articles are added to group" do
    assert_difference '@teachers.articles.size', 1 do
      # connect price to an article
      @price_one.article = @article_one

      # add price to teachers group
      @teachers.prices << @price_one
    end

    # now teachers group should be linked directly to article one
    assert_equal @article_one, @teachers.articles.find(@article_one)
  end
end
