require 'test_helper'

class CategoryTest < ActiveSupport::TestCase
  
  def setup
    @main_menu = categories(:main_menu)
    @snack = categories(:snack)
  end


  test "name is required" do
    @main_menu.name = nil
    assert !@main_menu.save
  end

  test "name is unique" do
    @main_menu.name = @snack.name
    assert !@main_menu.save
  end

  test "rank is required" do
    @main_menu.rank = nil
    assert !@main_menu.save
  end

  test "rank is unique" do
    @main_menu.rank = @snack.rank
    assert !@main_menu.save
  end

  test "rank is an integer" do
    @main_menu.rank = "NotANumber"
    assert !@main_menu.save

    @main_menu.rank = 10.5
    assert !@main_menu.save
  end

  test "rank is greater than zero" do
    @main_menu.rank = -1
    assert !@main_menu.save
  end

  test "orderable is required" do
    @main_menu.orderable = nil
    assert !@main_menu.save
  end

  test "orderable is a boolean value" do
    @main_menu.orderable = "not a bool"
    assert !@main_menu.save

    @main_menu.orderable = 2
    assert !@main_menu.save

    @main_menu.orderable = 2.5
    assert !@main_menu.save
  end

  test "preorderable is required" do
    @main_menu.preorderable = nil
    assert !@main_menu.save
  end

  test "preorderable is a boolean value" do
    @main_menu.preorderable = "not a bool"
    assert !@main_menu.save

    @main_menu.preorderable = 2
    assert !@main_menu.save

    @main_menu.preorderable = 2.5
    assert !@main_menu.save
  end
end
