require 'test_helper'

class BillTest < ActiveSupport::TestCase

  def setup
    @order_one = orders(:order_one)
    @order_two = orders(:order_two)
  end

  test "has a start_date" do
    @bill = Bill.new :end_date => Date.today, :amount => 7.5, :module => "mensa"
    assert !@bill.save

    @bill.start_date = Date.yesterday
    assert @bill.save
  end

  test "has an end_date" do
    @bill = Bill.new :start_date => Date.yesterday, :amount => 7.5, :module => "mensa"
    assert !@bill.save

    @bill.end_date = Date.today
    assert @bill.save
  end

  test "end_date may not be later than today" do
    @bill = Bill.new :start_date => Date.yesterday, :end_date => Date.tomorrow, :amount => 7.5, :module => "mensa"
    assert !@bill.save

    @bill.end_date = Date.today
    assert @bill.save
  end

  test "start_date is smaller than or equal to end_date" do
    @bill = Bill.new :start_date => Date.today, :end_date => Date.yesterday, :amount => 7.5, :module => "mensa"
    assert !@bill.save
    
    @bill.end_date = Date.today
    assert @bill.save
  end

  test "bill has an amount" do
    @bill = Bill.new :start_date => Date.yesterday, :end_date => Date.today, :module => "mensa"
    assert !@bill.save

    @bill.amount = 10
    assert @bill.save
  end

  test "bill has a module" do
    @bill = Bill.new :start_date => Date.yesterday, :end_date => Date.today, :amount => 10
    assert !@bill.save

    @bill.module = "mensa"
    assert @bill.save
  end

  test "amount is not smaller than zero" do
    @bill = Bill.new :start_date => Date.yesterday, :end_date => Date.today, :module => "mensa", :amount => -1
    assert !@bill.save

    @bill = Bill.new :start_date => Date.yesterday, :end_date => Date.today, :module => "mensa", :amount => 0
    assert @bill.save
  end

  test "amount is not greater than or equal to one billion" do
    @bill = Bill.new :start_date => Date.yesterday, :end_date => Date.today, :module => "mensa", :amount => 1000000000
    assert !@bill.save

    @bill.amount = 999999999
    assert @bill.save
  end

  test "has many orders attached" do
    @bill = Bill.new :start_date => Date.yesterday, :end_date => Date.today, :module => "mensa", :amount => 1000
    assert @bill.save

    assert_difference '@bill.orders.size', 2 do
      @bill.orders << @order_one
      @bill.orders << @order_two
      @bill.save
    end
  end
end
