require 'test_helper'

class ArticleTest < ActiveSupport::TestCase

  def setup
    @article_one = articles(:article_one)
    @price_one = prices(:price_one)
    @teachers = groups(:teachers)
    @order_one = orders(:order_one)
    @order_three = orders(:order_three)
  end

  test "article needs a name" do
    @article = Article.new :module => "mensa"
    assert !@article.save

    @article = Article.new :name => "Hauptmenü", :module => "mensa"
    assert @article.save
  end

  test "article needs a module" do
    @article = Article.new :name => "Hauptmenü"
    assert !@article.save

    @article = Article.new :name => "Hauptmenü", :module => "mensa"
    assert @article.save
  end

  test "article may have prices" do
    assert_difference '@article_one.prices.size', 1 do
      @article_one.prices << @price_one
    end

    assert_equal @price_one, @article_one.prices.find(@price_one)
  end

  #testing has many :through association
  test "groups are added to article" do
    assert_difference '@article_one.groups.size', 1 do
      # connect price to a group
      @price_one.group = @teachers

      # add price to article
      @article_one.prices << @price_one
    end
    
    # now article_one should be linked directly to the teachers group
    assert_equal @teachers, @article_one.groups.find(@teachers)
  end

  #testing has_many association
  test "articles can be ordered" do
    @order = Order.new :ordered_at => Time.now, :price => 10
    assert_difference '@article_one.orders.size', 1 do
      @article_one.orders << @order
    end

    assert_equal @order, @article_one.orders.find(@order)
  end

  #billing date is usefull to decide wether to bill the orders or wait
  test "article billing date defaults to Date.today" do
    @article = Article.new :name => "Hauptmenü", :module => "mensa"
    assert @article.save

    assert_equal Date.today, @article.billing_date
  end

end
