require 'test_helper'

class UserSessionsControllerTest < ActionController::TestCase
  setup :activate_authlogic

  def test_readiness_of_new_user_session
    get :new
    assert_response :success

    # Assert, that UserSession instance variable is set
    assert_not_nil assigns(:user_session)
  end

  def test_login_with_valid_parameters
    # Send valid paramauthlogic test_helper.rbeters to login function
    post :create, valid_user_session_params()

    assert_equal 'Erfolgreich angemeldet!', flash[:notice]
    assert_not_nil UserSession.find(valid_user_session_params())
    assert_redirected_to home_url
  end

  def test_login_without_valid_parameters
    # Send invalid parameters to login function
    post :create, :user_session=>{:remember_me =>"0", :password =>"falsch", :login =>"101"}

    assert_equal "Anmeldung nicht erfolgreich!", flash[:error]
    assert_nil UserSession.find(:user_session=>{:remember_me =>"0", :password =>"falsch", :login =>"101"})
    
    # we want to retry logging in therefore we are not redirected, the form is redrawn
    assert_response :success
  end

  def test_logout_is_successfull
    login_as(:alex)

    delete :destroy
    assert_equal  'Erfolgreich abgemeldet!', flash[:notice]
    assert_redirected_to login_url
    assert_nil UserSession.find(users(:alex))
  end

  test "destroy needs role user" do
    assert_nothing_raised do
      delete_with :guest, :destroy
    end
  end
end
