require 'test_helper'

class MenusControllerTest < ActionController::TestCase
  setup :activate_authlogic

  def setup
    login_as(:alex)
    @menu_one = menus(:menu_one)
    @spaghetti = meals(:spaghetti)
    @ŧeachers = groups(:teachers)
    @pupils = groups(:pupils)
  end

  test "menu is created and saved when meal given" do
    assert_difference 'Menu.count', 1 do
      post :create, :menu => {:date => Date.today.next_week, :meal_id => @spaghetti.id}, :meal => {:number =>  ''}, :prices => {'0' =>{:amount => '2.0', :group_id => @ŧeachers.id}, '1' => {:amount => '1.5', :group_id => @pupils.id}}
    end

    assert_equal flash[:notice], "Speiseangebot #{assigns(:menu).date.to_s(:german)} - #{assigns(:menu).meal.category.name} wurde erfolgreich angelegt!"
    assert_redirected_to menus_url
  end

  test "menu is created and saved when number given" do
    assert_difference 'Menu.count', 1 do
      post :create, :menu => {:date => Date.tomorrow, :meal_id => ''}, :meal => {:number =>  @spaghetti.number}, :prices => {'0' => {:amount => '2.0', :group_id => @ŧeachers.id}, '1' => {:amount => '1.5', :group_id => @pupils.id}}
    end

    assert_equal flash[:notice], "Speiseangebot #{assigns(:menu).date.to_s(:german)} - #{assigns(:menu).meal.category.name} wurde erfolgreich angelegt!"
    assert_redirected_to menus_url
  end

  test "menu is not created without parameters" do
    assert_no_difference 'Menu.count' do
      post :create, :menu => {:date => "", :meal_id => ''}, :meal => {:number =>  ''}, :prices => {'0' => {:amount => '', :group_id => ''}}
    end

    assert_redirected_to menus_url
  end

  test "index loads menus" do
    assert_no_difference 'Menu.count' do
      get :index
    end

    # Weeks object with menu of the following weeks
    assert_not_nil assigns(:weeks)

    #Menu object to create new Menu
    assert_not_nil assigns(:menu)

    assert_template :index
    assert_response :success
  end

  test "menu is deleted by id" do
    @price = Price.new :group => @pupils, :amount => "1.0"
    @menu = Menu.new :date => Date.tomorrow, :meal_id => @spaghetti.id
    @article = Article.new :name => "#{Date.tomorrow} -#{@spaghetti.category.name}", :module => "mensa", :billing_date => Date.tomorrow.tomorrow
    @article.prices << @price
    assert @article.save
    @menu.article = @article
    assert @menu.save

    assert_difference 'Menu.count', -1 do
      delete :destroy, :id => @menu.id
    end

    assert_equal flash[:notice], "Speiseangebot #{assigns(:menu).date.to_s(:german)} - #{assigns(:menu).meal.category.name} erfolgreich gelöscht!"
    assert_redirected_to menus_url
  end
end
