require 'test_helper'

class MenuOrdersControllerTest < ActionController::TestCase
  setup :activate_authlogic
  
  def setup
    login_as(:alex)
    @menu_one = menus(:menu_one)
    @menu_two = menus(:menu_two)
    @early_mealtime = mealtimes(:early_mealtime)
    @menu_order_one = menu_orders(:menu_order_one)
    @menu_order_two = menu_orders(:menu_order_two)
    @menu_order_three = menu_orders(:menu_order_three)

  end

  test "MenuOrder is created with correct values" do
    assert_difference 'MenuOrder.count', 1 do
      post :create, :orders =>{'0' => {:menu_id => @menu_one.id, :mealtime_id => @early_mealtime.id}}

      assert_not_nil assigns(:mealtime)
      assert_not_nil assigns(:menu)
      assert_not_nil assigns(:order)
      assert_not_nil assigns(:MenuOrder)
    end

    

    assert_equal flash[:notice], "Bestellung war erfolgreich!"
    assert_redirected_to menus_url
  end

  test "multiple MenuOrders is created with correct values" do
    assert_difference 'MenuOrder.count', 2 do
      post :create, :orders =>{'0' => {:menu_id => @menu_one.id, :mealtime_id => @early_mealtime.id}, '1' => {:menu_id => @menu_two.id, :mealtime_id => @early_mealtime.id}}
    end

    assert_equal flash[:notice], "Bestellung war erfolgreich!"
    assert_redirected_to menus_url
  end

  test "delete MenuOrder by id" do
    assert_difference 'MenuOrder.count', -1 do
      assert_difference 'Order.count', -1 do
        delete :destroy, :id => @menu_order_three.id
      end
    end

    assert_redirected_to menus_url
    assert_equal "Bestellung erfolgreich gelöscht!", flash[:notice]
  end

  test "delete only your own MenuOrders" do

    assert_no_difference 'MenuOrder.count' do
      assert_no_difference 'Order.count' do
        delete :destroy, :id => @menu_order_two.id
      end
    end

    assert_redirected_to menus_url
    assert_equal "Diese Bestellung kannst du nicht löschen!", flash[:error]
  end

  test "index is shown" do
    get :index

    assert_template :index
    assert_response :success
  end

  test "when index is given a date menus of this date are loaded" do
    get :index, :date => {:year => Date.today.year, :month => Date.today.month, :day => Date.today.day}

    if !Menu.find_all_by_date(Date.today()).nil?
      assert_not_nil assigns(:menus)
    end
    assert_not_nil assigns(:date)
    assert_not_nil assigns(:mealtimes)

    assert_template :index
    assert_response :success
  end
end
