require 'test_helper'

class BillsControllerTest < ActionController::TestCase
  setup :activate_authlogic

  def setup
    login_as(:alex)
    @bill_one = bills(:bill_one)
  end

  test "index is shown" do
    get :index

    assert_template :index
    assert_response :success
  end

  test "index action loads bills" do
    get :index

    @bills = Bill.find :all
    if @bills
      assert_not_nil assigns(:bills)
      assert_equal @bills, assigns(:bills)
    end
  end

  test "new bill is set" do
    get :new

    assert_not_nil assigns(:bill)
    assert_response :success
    assert_template :new
  end

  test "bill is created with correct values" do
    assert_difference 'Bill.count', 1 do
      post :create, :bill => {:start_date => Date.yesterday, :end_date => Date.today, :module => "mensa"}
    end

    assert_redirected_to bills_url
  end

  test "bill is not created with missing values" do
    assert_no_difference 'Bill.count' do
      post :create, :bill => {:start_date => '', :end_date => '', :module => ""}
    end

    assert_response :success
    assert_template :new
  end

  test "amount is sum of orders prices after create" do
    start_date = Date.yesterday
    end_date = Date.today
    module_name = "mensa"
    assert_difference 'Bill.count', 1 do
      post :create, :bill => {:start_date => start_date, :end_date => end_date, :module => module_name}
    end
    @newbill = Bill.find :last

    @articles = Article.find(:all, :conditions => ['module = ? and billing_date >= ? and billing_date <= ?', module_name, start_date, end_date])
    @orders = Array.new
    @articles.each {
      |article|
      article.orders.each {
        |order| @orders.push(order)
      }
    }
    price = 0
    @orders.each{
      |order| price += order.price
    }

    assert_equal price, @newbill.amount
    assert_redirected_to bills_url
  end

  test "show initializes bill object" do
    get :show, :id => @bill_one.id

    assert_not_nil assigns(:bill)
    assert_template :show
    assert_response :success
  end
end
