# This file is auto-generated from the current state of the database. Instead of editing this file, 
# please use the migrations feature of Active Record to incrementally modify your database, and
# then regenerate this schema definition.
#
# Note that this schema.rb definition is the authoritative source for your database schema. If you need
# to create the application database on another system, you should be using db:schema:load, not running
# all the migrations from scratch. The latter is a flawed and unsustainable approach (the more migrations
# you'll amass, the slower it'll run and the greater likelihood for issues).
#
# It's strongly recommended to check this file into your version control system.

ActiveRecord::Schema.define(:version => 20100406212105) do

  create_table "articles", :force => true do |t|
    t.string   "name"
    t.string   "module"
    t.integer  "product_id"
    t.string   "product_type"
    t.datetime "created_at"
    t.datetime "updated_at"
    t.date     "billing_date"
  end

  create_table "bills", :force => true do |t|
    t.string   "module"
    t.decimal  "amount",     :precision => 11, :scale => 2
    t.date     "start_date"
    t.date     "end_date"
    t.datetime "created_at"
    t.datetime "updated_at"
  end

  create_table "categories", :force => true do |t|
    t.string   "name"
    t.integer  "rank"
    t.boolean  "orderable"
    t.boolean  "preorderable"
    t.datetime "created_at"
    t.datetime "updated_at"
  end

  create_table "groups", :force => true do |t|
    t.string   "name"
    t.integer  "rank"
    t.datetime "created_at"
    t.datetime "updated_at"
  end

  create_table "groups_users", :id => false, :force => true do |t|
    t.integer "user_id"
    t.integer "group_id"
  end

  create_table "meals", :force => true do |t|
    t.string   "description"
    t.integer  "number"
    t.integer  "category_id"
    t.datetime "created_at"
    t.datetime "updated_at"
  end

  create_table "mealtimes", :force => true do |t|
    t.string   "name"
    t.integer  "rank"
    t.time     "start_time"
    t.time     "end_time"
    t.integer  "order_limit"
    t.datetime "created_at"
    t.datetime "updated_at"
  end

  create_table "menu_orders", :force => true do |t|
    t.boolean  "collected",   :default => false
    t.boolean  "postordered", :default => false
    t.datetime "pickup_time"
    t.datetime "created_at"
    t.datetime "updated_at"
    t.integer  "mealtime_id"
  end

  create_table "menus", :force => true do |t|
    t.date     "date"
    t.integer  "meal_id"
    t.datetime "created_at"
    t.datetime "updated_at"
  end

  create_table "orders", :force => true do |t|
    t.integer  "user_id"
    t.integer  "article_id"
    t.boolean  "paid",                                         :default => false
    t.datetime "ordered_at"
    t.decimal  "price",          :precision => 8, :scale => 2
    t.datetime "created_at"
    t.datetime "updated_at"
    t.integer  "sub_order_id"
    t.string   "sub_order_type"
    t.integer  "bill_id"
  end

  create_table "prices", :force => true do |t|
    t.decimal  "amount",     :precision => 8, :scale => 2
    t.integer  "group_id"
    t.integer  "article_id"
    t.datetime "created_at"
    t.datetime "updated_at"
  end

  create_table "roles", :force => true do |t|
    t.string   "name"
    t.datetime "created_at"
    t.datetime "updated_at"
  end

  create_table "roles_users", :id => false, :force => true do |t|
    t.integer "role_id"
    t.integer "user_id"
  end

  create_table "users", :force => true do |t|
    t.string   "login",                               :null => false
    t.string   "email"
    t.string   "forename",                            :null => false
    t.string   "surname",                             :null => false
    t.boolean  "enabled",           :default => true
    t.string   "crypted_password"
    t.string   "password_salt"
    t.string   "persistence_token"
    t.datetime "created_at"
    t.datetime "updated_at"
  end

end
