authorization do

  role :guest do
    has_permission_on :home, :to => [:index]
  end

  role :user do
    includes :guest
    
    has_permission_on :users, :to => [:update]
    has_permission_on :menu_orders, :to => [:create]
    has_permission_on :menus, :to => [:index]

  end

  role :admin do
    includes :user

    has_permission_on :users, :to => [:manage, :update_all]
    has_permission_on :groups, :to => [:manage]
    has_permission_on :categories, :to => [:manage]
    has_permission_on :mealtimes, :to => [:manage]
    has_permission_on :meals, :to => [:manage]
    has_permission_on :menus, :to => [:manage]
    has_permission_on :menu_orders, :to => [:manage]
    has_permission_on :bills, :to => [:manage]
  end

  
end

privileges do
  # default privilege hierarchies to facilitate RESTful Rails apps
  privilege :manage, :includes => [:create, :read, :update, :delete]
  privilege :read, :includes => [:index, :show]
  privilege :create, :includes => :new
  privilege :update, :includes => :edit
  privilege :delete, :includes => :destroy
end
