class User < ActiveRecord::Base
  acts_as_authentic do |c|
    #email is not necessary should therefore not be checked
    c.validate_email_field = false
  end

  has_and_belongs_to_many :groups
  has_and_belongs_to_many :roles

  validates_presence_of :forename, :surname

  #this method is obligatory for authorization system
  def role_symbols
    (self.roles || []).map {|r| r.name.downcase.to_sym}
  end
end
