class Order < ActiveRecord::Base
  validates_presence_of :ordered_at, :price
  validates_numericality_of :price, :greater_than_or_equal_to => 0, :less_than => 1000000

  belongs_to :user
  belongs_to :article
  belongs_to :sub_order, :polymorphic => true
  belongs_to :bill
end