class MenuOrder < ActiveRecord::Base
  has_one :main_order, :as => :sub_order, :class_name => 'Order'
  belongs_to :mealtime

  validates_presence_of :main_order

  def menu
    return self.main_order.article.product if self.main_order.article.product_type == 'Menu'
  end

  def user
    return self.main_order.user
  end
end
