class Menu < ActiveRecord::Base
  belongs_to :meal
  has_one :article, :as => :product

  validates_presence_of :date, :meal, :article

  def validate
    # this validation checks if there is no other menu of the same category for this date
    # ~validates_uniqueness_of :meal.category_id, :scope => :date
    menus = Menu.find_all_by_date(date)
    menus.each do |menu|
      if menu.meal.category_id == meal.category_id
        errors.add(:meal, "Es ist bereits ein Menü für die Kategorie #{meal.category.name} eingetragen!")
      end
    end

    #this validates the billing date of the aticle is set one day after the menus (delivery) date
    if date and article and article.billing_date
      if article.billing_date != date.next
        errors.add(:article, "Der zum Menü gehörende Artikel hat ein falsches Abrechnungsdatum!")
      end
    end
  end

  def price_for_user(user)
    grouprank = nil
    
    # take every price associated with the article object of this menu
    for price in self.article.prices do

      #test if rank of this prices group is lower than previously seen rank
      if(grouprank == nil or grouprank > price.group.rank)
        #if so this price is the new all time low

        #save amount in return Value
        lowRankPrice = price.amount

        #remember rank of lowest price
        grouprank = price.group.rank
      end
    end
    return lowRankPrice
  end

  def menu_orders_for_user(user)
    orders = self.article.orders
    orders.delete_if{|order| order.user != user}
    return orders.collect {| obj | obj.sub_order }
  end

  def menu_orders
    orders = self.article.orders
    return orders.collect {| obj | obj.sub_order }
  end
end
