class Mealtime < ActiveRecord::Base
  has_many :menu_orders

  validates_presence_of :name, :rank, :order_limit
  validates_time :start_time, :allow_nil => false, :before => :end_time
  validates_time :end_time, :allow_nil => false
  validates_uniqueness_of :name, :rank
  validates_numericality_of :rank, :only_integer => true, :greater_than_or_equal_to => 1
  validates_numericality_of :order_limit, :only_integer => true, :greater_than_or_equal_to => 0
end
