class Meal < ActiveRecord::Base
  belongs_to :category
  has_many :menus

  validates_presence_of :description, :number, :category_id
  validates_numericality_of :number, :only_integer => true, :greater_than => 0
  validates_uniqueness_of :number
end
