class Group < ActiveRecord::Base
  has_and_belongs_to_many :members, :class_name => "User"
  has_many :prices
  has_many :articles, :through => :prices

  validates_presence_of :name, :rank
  validates_uniqueness_of :name, :rank
  validates_numericality_of :rank, :only_integer => true, :greater_than => 0
end
