class Category < ActiveRecord::Base
  validates_presence_of :name, :rank
  validates_inclusion_of :orderable, :in => [true, false]
  validates_inclusion_of :preorderable, :in => [true, false]
  validates_uniqueness_of :name, :rank
  validates_numericality_of :rank, :only_integer => true, :greater_than => 0
end
