class Bill < ActiveRecord::Base
  has_many :orders

  validates_presence_of :amount, :module
  validates_date :start_date, :on_or_before => :end_date
  validates_date :end_date, :on_or_after => :start_date, :on_or_before => Date.today
  validates_numericality_of :amount, :greater_than_or_equal_to => 0, :less_than => 1000000000
end
