class Article < ActiveRecord::Base
  has_many :prices
  has_many :groups, :through => :prices
  has_many :orders
  belongs_to :product, :polymorphic => true

  validates_presence_of :name, :module

  def billing_date
    #billing date defaults to today
    self[:billing_date] or Date.today
  end
end