class UsersController < ApplicationController
  before_filter :require_user
  filter_access_to :all

  def index
    @users = User.find :all, :order => "login"
  end

  def new
    @user = User.new
  end

  def create
    @user = User.new(params[:user])
    if @user.save
      flash[:notice] = "Benutzer #{@user.login} erfolgreich angelegt!"
      redirect_to new_user_url
    else
      render :action => :new
    end
  end

  def edit
    if params[:id]
      @user = User.find params[:id]
      render "edit_all_features"
    else
      @user = @current_user
    end    
  end

  def update
    @user = @current_user

    #only update email and password. other values are updatet with update_all
    if @user.update_attribute(:email, params[:user][:email]) && @user.update_attribute(:password, params[:user][:password])
      flash[:notice] = "Profil erfolgreich bearbeitet!"
      redirect_to edit_account_url
    else
      render :action => :edit
    end
  end

  def update_all
    if params[:id]
      @user = User.find params[:id]
    else
      flash[:error] = "Kein Benutzer ausgewählt!"
      redirect_to users_url
    end

    if @user.update_attributes(params[:user])
      flash[:notice] = "Änderungen erfolgreich gespeichert!"
      redirect_to users_url
    else
      render :action => :edit
    end
  end

  def destroy
    @user = User.find(params[:id])

    if @user != current_user
      @user.destroy
      flash[:notice] = "Benutzer #{@user.login} erfolgreich gelöscht!"
    else
      flash[:error] = "Sie können sich nicht selbst löschen!"
    end
    redirect_to users_url
  end
end
