class UserSessionsController < ApplicationController
  before_filter :require_no_user, :only => [:new, :create]
  before_filter :require_user, :only => :destroy
  

  def new
    @user_session = UserSession.new
  end

  def create
    @user_session = UserSession.new(params[:user_session])
    if @user_session.save
      flash[:notice] = "Erfolgreich angemeldet!"
      redirect_back_or_default home_url
    else
      flash[:error] = "Anmeldung nicht erfolgreich!"
      render :action => :new
    end
  end

  def destroy
    current_user_session.destroy
    flash[:notice] = "Erfolgreich abgemeldet!"
    redirect_back_or_default login_url
  end
end