class MenusController < ApplicationController
  before_filter :require_user
  filter_access_to :all

  def index
    # Start Day is this weeks monday
    start_day = Date.today.at_beginning_of_week
    @weeks = Array.new

    # getting the menu for the next x weeks
    APP_CONFIG['mensa_menu_show_weeks'].times do
      @week = Array.new

      # getting every day by itself and store it with date
      7.times do
        @menus = Menu.find_all_by_date start_day
        @week.push({:date => start_day, :menus => @menus})

        #advance one day after every iteration
        start_day = start_day.tomorrow
      end

      #as week is filled with 7 dates and up to seven menu arrays add to weeks array
      @weeks.push(@week)
    end

    # Menu object for creation of new menu
    @menu = Menu.new
  end

  def create
    @menu = Menu.new params[:menu]

    # meal can be selected by number or id (select)
    # id is dealt with via Menu.new, this tests for the number
    if params[:meal][:number]
      @meal = Meal.find_by_number params[:meal][:number]
      if !@meal.nil?
        @menu.meal = @meal
      end
    end

    if !@menu.meal.nil?
      # every menu needs an article
      @article = Article.new :name => "#{@menu.date.to_s()} -#{@menu.meal.category.name}", :module => "mensa", :billing_date => @menu.date.tomorrow

      # articles may have several prices
      if params[:prices]
        params[:prices].each do |key, price|
          @price = Price.new price
          if @price.save
            @article.prices << @price
          end
        end
      end

      #there may not be a menu without article, therefore don't save menu before article
      if @article.save
        @menu.article = @article

        if @menu.save
          flash[:notice] = "Speiseangebot #{@menu.date.to_s(:german)} - #{@menu.meal.category.name} wurde erfolgreich angelegt!"
        else
          flash[:error] = "Speiseangebot nicht erfolgreich gespeichert!"
        end
      else
        flash[:error] = "Artikel nicht erfolgreich gespeichert!"
      end
    else
      flash[:error] = "Keine Speise ausgewählt!"
    end
    redirect_to menus_url
  end

  def destroy
    @menu = Menu.find params[:id]
    @menu.destroy
    flash[:notice] = "Speiseangebot #{@menu.date.to_s(:german)} - #{@menu.meal.category.name} erfolgreich gelöscht!"
    redirect_to menus_url
  end
end
