class MenuOrdersController < ApplicationController
  before_filter :require_user
  filter_access_to :all

  def index
    # lists number of menuordes for menus if date is given
    if params[:date]
      dateparam = Date.new(params[:date][:year].to_i, params[:date][:month].to_i, params[:date][:day].to_i)
      @menus = Menu.find_all_by_date dateparam
      @date = dateparam
      @mealtimes = Mealtime.find :all, :order => "rank ASC"
    end
  end

  def create
    if params[:orders]
      params[:orders].each do |key, order|
        @mealtime = Mealtime.find_by_id order[:mealtime_id]
        @menu = Menu.find_by_id order[:menu_id]

        # MenuOrder needs a menu and an order and currently also a mealtime
        if !@menu.nil? and !@mealtime.nil?
          @order = Order.new :ordered_at => Time.now, :price => @menu.price_for_user(current_user), :article => @menu.article, :user => current_user

          @MenuOrder = MenuOrder.new
          @MenuOrder.mealtime = @mealtime
          @MenuOrder.main_order = @order
          @MenuOrder.save
        end
      end
      flash[:notice] = "Bestellung war erfolgreich!"
    end
        
    redirect_to menus_url
  end

  def destroy
    @MenuOrder = MenuOrder.find params[:id]

    if @MenuOrder.main_order.user == current_user
      @MenuOrder.main_order.destroy
      @MenuOrder.destroy
      flash[:notice] = "Bestellung erfolgreich gelöscht!"
    else
      flash[:error] = "Diese Bestellung kannst du nicht löschen!"
    end
    redirect_to menus_url
  end
end
