class MealtimesController < ApplicationController
  before_filter :require_user
  filter_access_to :all

  def index
    @mealtimes = Mealtime.find :all, :order => "rank ASC"
  end

  def new
    @mealtime = Mealtime.new
  end

  def create
    @mealtime = Mealtime.new params[:mealtime]

    if @mealtime.save
      flash[:notice] = "Essenszeit #{@mealtime.name} wurde erfolgreich angelegt!"
      redirect_to mealtimes_url
    else
      render :action => :new
    end
  end

  def edit
    if params[:id]
      @mealtime = Mealtime.find params[:id]
    else
      flash[:error] = "Eine Essenszeit mit dieser ID gibt es nicht!"
      redirect_to mealtimes_url
    end
  end

  def update
    @mealtime = Mealtime.find params[:id]
    if @mealtime.update_attributes(params[:mealtime])
      flash[:notice] = "Änderungen erfolgreich gespeichert"
      redirect_to mealtimes_url
    else
      render :action => :edit
    end
  end

  def destroy
    @mealtime = Mealtime.find params[:id]
    @mealtime.destroy
    flash[:notice] = "Essenszeit #{@mealtime.name} erfolgreich gelöscht!"
    redirect_to mealtimes_url
  end
end
