class MealsController < ApplicationController
  before_filter :require_user
  filter_access_to :all

  def index
    @meals = Meal.find :all, :order => "number ASC"
  end

  def new
    @meal = Meal.new
  end

  def create
    @meal = Meal.new params[:meal]

    if @meal.save
      flash[:notice] = "Speise #{@meal.description} wurde erfolgreich angelegt!"
      redirect_to meals_url
    else
      render :action => :new
    end
  end

  def edit
    if params[:id]
      @meal = Meal.find params[:id]
    else
      flash[:error] = "Eine Speise mit dieser ID gibt es nicht!"
      redirect_to meals_url
    end
  end

  def update
    @meal = Meal.find params[:id]
    if @meal.update_attributes(params[:meal])
      flash[:notice] = "Änderungen erfolgreich gespeichert"
      redirect_to meals_url
    else
      render :action => :edit
    end
  end

  def destroy
    @meal = Meal.find params[:id]
    @meal.destroy
    flash[:notice] = "Speise #{@meal.description} erfolgreich gelöscht!"
    redirect_to meals_url
  end
end
