class GroupsController < ApplicationController
  before_filter :require_user
  filter_access_to :all

  def index
    @groups = Group.find :all, :order => "rank ASC"
  end

  def new
    @group = Group.new
  end

  def create
    @group = Group.new params[:group]

    if @group.save
      flash[:notice] = "Gruppe #{@group.name} wurde erfolgreich angelegt!"
      redirect_to new_group_url
    else
      render :action => :new
    end    
  end

  def update
    @group = Group.find params[:id]
    if @group.update_attributes(params[:group])
      flash[:notice] = "Änderungen erfolgreich gespeichert"
      redirect_to groups_url
    else
      render :action => :edit
    end    
  end

  def edit
    if params[:id]
      @group = Group.find params[:id]
    else
      flash[:error] = "Eine Gruppe mit dieser ID gibt es nicht!"
      redirect_to groups_url
    end
  end

  def destroy
    @group = Group.find params[:id]
    @group.destroy
    flash[:notice] = "Gruppe #{@group.name} erfolgreich gelöscht!"
    redirect_to groups_url
  end
end
