class CategoriesController < ApplicationController
  before_filter :require_user
  filter_access_to :all
  
  def index
    @categories = Category.find :all, :order => "rank ASC"
  end

  def new
    @category = Category.new
  end

  def create
    @category = Category.new params[:category]

    if @category.save
      flash[:notice] = "Kategorie #{@category.name} wurde erfolgreich angelegt!"
      redirect_to categories_url
    else
      render :action => :new
    end
  end

  def edit
    if params[:id]
      @category = Category.find params[:id]
    else
      flash[:error] = "Eine Kategorie mit dieser ID gibt es nicht!"
      redirect_to categories_url
    end
  end

  def update
    @category = Category.find params[:id]
    if @category.update_attributes(params[:category])
      flash[:notice] = "Änderungen erfolgreich gespeichert"
      redirect_to categories_url
    else
      render :action => :edit
    end
  end

  def destroy
    @category = Category.find params[:id]
    @category.destroy
    flash[:notice] = "Kategorie #{@category.name} erfolgreich gelöscht!"
    redirect_to categories_url
  end
end
