class BillsController < ApplicationController
  before_filter :require_user
  filter_access_to :all

  def index
    @bills = Bill.find :all
  end

  def new
    @bill = Bill.new
  end

  def create
    if params[:bill]
      @bill = Bill.new params[:bill]

      @bill.amount = 0

      #get the articles with billing date in selected intervall
      @articles = Article.find(:all, :conditions => ['module = ? and billing_date >= ? and billing_date <= ?', @bill.module, @bill.start_date, @bill.end_date])
      @articles.each {
        |article|
        article.orders.each {
          |order|
          #amount of bill has to be increased
          @bill.amount += order.price

          #add order to list of bills
          order.bill = @bill
          order.paid = true
          order.save
        }
      }
      
      if @bill.save
        redirect_to bills_url
      else
        render :action => :new
      end
    else
      render :action => :new
    end
  end

  def show
    @bill = Bill.find params[:id]
  end
end
