# esv is a webapplication aiming at simplifying the management of educational organisations
#
# Copyright (C) [2010] [Armin Feistenauer]
#
# This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with this program; if not, see <http://www.gnu.org/licenses/>.
#
###############################################################################################
#
# Filters added to this controller apply to all controllers in the application.
# Likewise, all the methods added will be available for all controllers.

class ApplicationController < ActionController::Base
  helper :all # include all helpers, all the time
  protect_from_forgery # See ActionController::RequestForgeryProtection for details

  helper_method :current_user_session, :current_user, :permission_denied, :start_time

  # it is recommended to stop rails from logging sensitive parameters
  filter_parameter_logging :password, :password_confirmation

  before_filter :set_current_user, :set_start_time

  def permission_denied
    flash[:error] = 'Diese Seite darfst du nicht anzeigen.'
    redirect_to home_url
  end

  private
    def current_user_session
      return @current_user_session if defined?(@current_user_session)
      @current_user_session = UserSession.find
    end

    def current_user
      return @current_user if defined?(@current_user)
      @current_user = current_user_session && current_user_session.record
    end

    def require_user
      unless current_user
        store_location
        flash[:notice] = "Um diese Seite zu sehen musst du angemeldet sein!"
        redirect_to login_url
        return false
      end
    end
 
    def require_no_user
      if current_user
        store_location
        #flash[:notice] = "Um diese Seite zu sehen musst du abgemeldet sein!"
        redirect_to home_url
        return false
      end
    end
    
    def store_location
      session[:return_to] = request.request_uri
    end

    def redirect_back_or_default(default)
      redirect_to(session[:return_to] || default)
      session[:return_to] = nil
    end

    def start_time
      return @start_time
    end
    
  protected
    def set_current_user
      Authorization.current_user = current_user
    end

    def set_start_time
      @start_time = Time.now
    end
end
